#version 330
#extension GL_EXT_gpu_shader4 : enable
//more mountainsMod01.fsh  by   yonatan
//https://www.shadertoy.com/view/XsBSWw
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float km = 0.3;

float h1(vec2 p) {
    return textureLod(iChannel0, p.xy*.03, 0.0).x;
}

float h(vec2 p) {
    float ret = 0.0;
    float m = 1.0;
    for(int i=0; i<8; i++) {
        ret += m * h1(p/m);
        m *= -0.5;
    }
    return ret * ret;
}

float df(vec3 p) {
    return p.y - h(p.xz);
}

mat3 rotationXY( vec2 angle ) {
	vec2 c = cos( angle );
	vec2 s = sin( angle );
	return mat3(
		c.y      ,  0.0, -s.y      ,
		s.y * s.x,  c.x,  c.y * s.x,
		s.y * c.x, -s.x,  c.y * c.x
	);
}

// from https://iquilezles.org/articles/rmshadows
float softshadow( in vec3 ro, in vec3 rd, float mint, float maxt, float k ) {
    float res = 1.0;
    float t=mint;
    for(int i=0;i<8; i++) {
        if(t>maxt) break;
        float h = df(ro + rd*t);
        if( h<0.001 )
            return 0.0;
        res = min( res, k*h/t );
        t += h*km;
    }
    return res;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )	
{
	vec2 p2=(gl_FragCoord.xy/iResolution.xy)*2.0-1.0;
    vec2 m=iMouse.yx/iResolution.yx*2.-1.;
    m.y = -m.y;
    vec3 ldir = normalize(vec3(-1.0,.01,.01));
	vec3 o = vec3(0.0, 0.0, iTime * .2);
    o.y = h1(o.xz) + .2;
    mat3 rot = rotationXY(m*vec2(0.5,4.0)+vec2(0.5,0.0));
    //mat3 rot = rotationXY(m+vec2(1.,0.0));
	vec3 dir = rot * normalize(vec3(p2*vec2(1.77,1.0),2.0));		// screen ratio (x,y) fov (z)
	vec3 hit;
	float t=0.0, k;
	for(int i=0;i<40;i++) {
		k=df(hit=o+dir*t);
		t+=k*km;
	}
    vec2 e=vec2(-0.01, 0.0);
    float hh = h((hit.xz)*128.);
    hit += hh * vec3(0.007, -0.002, 0.007);
    vec3 n = normalize(vec3(k-df(hit+e.xyy), k-df(hit+e.yxy), k-df(hit+e.yyx)));
    float ss = softshadow(hit, ldir, .01, 1.0, 1.0 );
    float dif = dot(n,ldir);
    vec3 fogc = mix(vec3(.86,.89,.9), vec3(1.2,1.1,1.0), (pow(1.0+dot(dir,ldir), 2.0))*.25);
    vec3 c = vec3(.6,.5,.4) *  (dif + .1) * (ss + .1);
    c = mix(c, fogc, min(1.0,t*.4));
    gl_FragColor = vec4(c,1.0);
}
